% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_simulate_simple.R
\name{brm_simulate_simple}
\alias{brm_simulate_simple}
\title{Simple MMRM simulation.}
\usage{
brm_simulate_simple(
  n_group = 2L,
  n_patient = 100L,
  n_time = 4L,
  hyper_beta = 1,
  hyper_tau = 0.1,
  hyper_lambda = 1
)
}
\arguments{
\item{n_group}{Positive integer of length 1, number of treatment groups.}

\item{n_patient}{Positive integer of length 1, number of patients
per treatment group.}

\item{n_time}{Positive integer of length 1, number of discrete
time points (e.g. scheduled study visits) per patient.}

\item{hyper_beta}{Positive numeric of length 1, hyperparameter.
Prior standard deviation of the fixed effect parameters \code{beta}.}

\item{hyper_tau}{Positive numeric of length 1, hyperparameter.
Prior standard deviation parameter of the residual log standard
deviation parameters \code{tau}}

\item{hyper_lambda}{Positive numeric of length 1, hyperparameter.
Prior shape parameter of the LKJ correlation matrix of the residuals
among discrete time points.}
}
\value{
A list of three objects:
\itemize{
\item \code{data}: A tidy dataset with one row per patient per discrete
time point and columns for the outcome and ID variables.
\item \code{model_matrix}: A matrix with one row per row of \code{data} and columns
that represent levels of the covariates.
\item \code{parameters}: A named list of parameter draws sampled from the prior:
\itemize{
\item \code{beta}: numeric vector of fixed effects.
\item \code{tau}: numeric vector of residual log standard parameters for each
time point.
\item \code{sigma}: numeric vector of residual standard parameters for each
time point. \code{sigma} is equal to \code{exp(tau)}.
\item \code{lambda}: correlation matrix of the residuals among the time points
within each patient.
\item \code{covariance}: covariance matrix of the residuals among the time points
within each patient. \code{covariance} is equal to
\code{diag(sigma) \%*\% lambda \%*\% diag(sigma)}.
}
}
}
\description{
Simple function to simulate a dataset from a simple
specialized MMRM.
}
\details{
Refer to the methods vignette for a full model specification.
The \code{\link[=brm_simulate_simple]{brm_simulate_simple()}} function simulates a dataset from a
simple pre-defined MMRM. It assumes a cell means structure for fixed
effects, which means there is one fixed effect scalar parameter
(element of vector \code{beta}) for each unique combination of levels of
treatment group and discrete time point.
The elements of \code{beta} have independent univariate normal
priors with mean 0 and standard deviation \code{hyper_beta}.
The residual log standard deviation parameters (elements of vector \code{tau})
have normal priors with mean 0 and standard deviation \code{hyper_tau}.
The residual correlation matrix parameter \code{lambda} has an LKJ correlation
prior with shape parameter \code{hyper_lambda}.
}
\examples{
set.seed(0L)
simulation <- brm_simulate_simple()
simulation$data
}
\seealso{
Other simulation: 
\code{\link{brm_simulate_categorical}()},
\code{\link{brm_simulate_continuous}()},
\code{\link{brm_simulate_outline}()},
\code{\link{brm_simulate_prior}()}
}
\concept{simulation}
