% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{log_lik.brmsfit}
\alias{log_lik.brmsfit}
\alias{log_lik}
\alias{logLik.brmsfit}
\title{Compute the Pointwise Log-Likelihood}
\usage{
\method{log_lik}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  resp = NULL, nsamples = NULL, subset = NULL, pointwise = FALSE,
  combine = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{nsamples}{Positive integer indicating how many posterior samples should
be used. If \code{NULL} (the default) all samples are used. Ignored if
\code{subset} is not \code{NULL}.}

\item{subset}{A numeric vector specifying the posterior samples to be used.
If \code{NULL} (the default), all samples are used.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once (the default), or just return
the likelihood function along with all data and samples
required to compute the log-likelihood separately for each
observation. The latter option is rarely useful when
calling \code{log_lik} directly, but rather when computing
\code{\link{waic}} or \code{\link{loo}}.}

\item{combine}{Only relevant in multivariate models.
Indicates if the log-likelihoods of the submodels should
be combined per observation (i.e. added together; the default) 
or if the log-likelihoods should be returned separately.}

\item{...}{Further arguments passed to \code{\link{extract_draws}}
that control several aspects of data validation and prediction.}
}
\value{
Usually, an S x N matrix containing the pointwise log-likelihood
 samples, where S is the number of samples and N is the number 
 of observations in the data. For multivariate models and if 
 \code{combine} is \code{FALSE}, an S x N x R array is returned, 
 where R is the number of response variables.
 If \code{pointwise = TRUE}, the output is a function
 with a \code{draws} attribute containing all relevant
 data and posterior samples.
}
\description{
Compute the Pointwise Log-Likelihood
}
