% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{fitted.brmsfit}
\alias{fitted.brmsfit}
\alias{posterior_linpred.brmsfit}
\alias{posterior_linpred}
\title{Extract Model Fitted Values of \code{brmsfit} Objects}
\usage{
\method{fitted}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  scale = c("response", "linear"), resp = NULL, dpar = NULL,
  nlpar = NULL, nsamples = NULL, subset = NULL, sort = FALSE,
  summary = TRUE, robust = FALSE, probs = c(0.025, 0.975), ...)

\method{posterior_linpred}{brmsfit}(object, transform = FALSE,
  newdata = NULL, re_formula = NULL, re.form = NULL, resp = NULL,
  dpar = NULL, nlpar = NULL, nsamples = NULL, subset = NULL,
  sort = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{scale}{Either \code{"response"} or \code{"linear"}. 
If \code{"response"} results are returned on the scale 
of the response variable. If \code{"linear"} 
fitted values are returned on the scale of the linear predictor.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{dpar}{Optional name of a predicted distributional parameter.
If specified, fitted values of this parameters are returned.}

\item{nlpar}{Optional name of a predicted non-linear parameter.
If specified, fitted values of this parameters are returned.}

\item{nsamples}{Positive integer indicating how many posterior samples should
be used. If \code{NULL} (the default) all samples are used. Ignored if
\code{subset} is not \code{NULL}.}

\item{subset}{A numeric vector specifying the posterior samples to be used.
If \code{NULL} (the default), all samples are used.}

\item{sort}{Logical. Only relevant for time series models. 
Indicating whether to return predicted values in the original 
order (\code{FALSE}; default) or in the order of the 
time series (\code{TRUE}).}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{extract_draws}}
that control several aspects of data validation and prediction.}

\item{transform}{Logical; alias of \code{scale}.
If \code{TRUE}, \code{scale} is set to \code{"response"}.
If \code{FALSE}, \code{scale} is set to \code{"linear"}. 
Only implemented for compatibility with the 
\code{\link[rstantools:posterior_linpred]{posterior_linpred}}
generic.}

\item{re.form}{Alias of \code{re_formula}.}
}
\value{
Fitted values extracted from \code{object}. 
 The output depends on the family:
 If \code{summary = TRUE} it is a N x E x C array 
 for categorical and ordinal models and a N x E matrix else.
 If \code{summary = FALSE} it is a S x N x C array 
 for categorical and ordinal models and a S x N matrix else.
 N is the number of observations, S is the number of samples, 
 C is the number of categories, and E is equal to \code{length(probs) + 2}.
 In multivariate models, the output is an array of 3 dimensions, 
 where the third dimension indicates the response variables.
}
\description{
Predict mean values of the response distribution (i.e., the 'regression line')
for a fitted model. Can be performed for the data used to fit the model 
(posterior predictive checks) or for new data.
By definition, these predictions have smaller variance
than the response predictions performed by
the \code{\link[brms:predict.brmsfit]{predict}} method. 
This is because the measurement error is not incorporated.
The estimated means of both methods should, however, be very similar.
}
\details{
\code{NA} values within factors in \code{newdata}, 
  are interpreted as if all dummy variables of this factor are 
  zero. This allows, for instance, to make predictions of the grand mean 
  when using sum coding.
  
  Method \code{posterior_linpred.brmsfit} is an alias of 
  \code{fitted.brmsfit} with \code{scale = "linear"} and
  \code{summary = FALSE}.
}
\examples{
\dontrun{
## fit a model
fit <- brm(rating ~ treat + period + carry + (1|subject), 
           data = inhaler)

## extract fitted values
fitted_values <- fitted(fit)
head(fitted_values)

## plot fitted means against actual response
dat <- as.data.frame(cbind(Y = standata(fit)$Y, fitted_values))
ggplot(dat) + geom_point(aes(x = Estimate, y = Y))
}

}
