% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropnests.R
\name{dropnests}
\alias{dropnests}
\alias{dropnests.default}
\title{Drop Redundant List Nesting}
\usage{
dropnests(x, ...)

\method{dropnests}{default}(x, maxdepth = 16L, recurse_classed = FALSE, ...)
}
\arguments{
\item{x}{a list}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{maxdepth}{a single, positive integer,
giving the maximum depth to recurse into the list. \cr
The surface-level elements of a list is depth 1. \cr
\code{dropnests(x, maxdepth = 1)} will return \code{x} unchanged.}

\item{recurse_classed}{\code{TRUE} or \code{FALSE},
indicating if the function should also recurse through classed lists within \code{x},
like data.frames.}
}
\value{
A list without redundant nesting. \cr
Attributes are preserved. \cr
\cr
}
\description{
\code{dropnests()} drops redundant nesting of a list. \cr
It is the hierarchical equivalent to the dimensional \code{base::drop()} function. \cr
\cr
}
\examples{

x <- list(
  a = list(list(list(list(1:10)))),
  b = list(1:10)
)
print(x)


dropnests(x)


# recurse_classed demonstration ====
x <- list(
  a = list(list(list(list(1:10)))),
  b = data.frame(month.abb, month.name),
  c = data.frame(month.abb)
)


dropnests(x) # by default, recurse_classed = FALSE

dropnests(x, recurse_classed = TRUE)


# maxdepth demonstration ====
x <- list(
  a = list(list(list(list(1:10)))),
  b = list(1:10)
)
print(x)


dropnests(x) # by default, maxdepth = 16

dropnests(x, maxdepth = 3L)

dropnests(x, maxdepth = 1L) # returns `x` unchanged

}
\seealso{
\link{broadcast_casting} \cr
}
