% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier2dim.R
\name{hier2dim}
\alias{hier2dim}
\alias{hiernames2dimnames}
\alias{hier2dim.default}
\alias{hiernames2dimnames.default}
\title{Helper Functions For cast_hier2dim}
\usage{
hier2dim(x, ...)

hiernames2dimnames(x, ...)

\method{hier2dim}{default}(x, in2out = TRUE, maxdepth = 16L, recurse_all = FALSE, ...)

\method{hiernames2dimnames}{default}(
  x,
  in2out = TRUE,
  maxdepth = 16L,
  recurse_all = FALSE,
  direction = 1,
  ...
)
}
\arguments{
\item{x}{a nested list. \cr
If \code{x} has redundant nesting,
it is advisable (though not necessary) to reduce the redundant nesting using \link{dropnests}.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{in2out, recurse_all}{see \link{broadcast_casting}.}

\item{maxdepth}{a single, positive integer,
giving the maximum depth to recurse into the list. \cr
The surface-level elements of a list is depth 1. \cr}

\item{direction}{A single number, giving the direction in which to search for names. \cr
Must be either \code{1} (to search from start to end) or \code{-1} (to search from end to start). \cr
If set to \code{0}, the result will simply be \code{NULL}.}
}
\value{
For \code{hier2dim()}: \cr
An integer vector,
giving the dimensions \code{x} would have,
if casted by \code{cast_hier2dim()}. \cr
The names of the output indicates if padding is required (name "padding"),
or no padding is required (no name) for that dimension; \cr
Padding will be required if not all list-elements at a certain depth have the same length. \cr
\cr
For \code{hiernames2dimnames()}: \cr
A list of \code{dimnames}; these can be assigned to the \code{dimnames} of the result of \link{cast_hier2dim}. \cr
\cr
}
\description{
\code{hier2dim()} takes a hierarchical/nested list,
and predicts what dimensions the list would have,
if casted by the \link{cast_hier2dim} function. \cr
\cr
\code{hiernames2dimnames()} takes a hierarchical/nested list,
and intelligently tries to compose dimnames for the result of \link{cast_hier2dim}. \cr
\cr
}
\examples{


# Example 1: Basics ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# predict what dimensions `x` would have if casted as dimensional:
hier2dim(x)

x2 <- cast_hier2dim(x) # cast as dimensional

# since the original list uses the same names for all elements within the same depth,
# dimnames can be set easily:
dimnames(x2) <- hiernames2dimnames(x)

print(x2)


# Example 2: Cast from outside to inside ====
x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)

# by default, `in2out = TRUE`;
# for this example, `in2out = FALSE` is used

# predict what dimensions `x` would have if casted as dimensional:
hier2dim(x, in2out = FALSE)

x2 <- cast_hier2dim(x, in2out = FALSE) # cast as dimensional

# since the original list uses the same names for all elements within the same depth,
# dimnames can be set easily:
# because in2out = FALSE, go from the shallow names to the deeper names:
dimnames(x2) <- hiernames2dimnames(x, in2out = FALSE)

print(x2)



# Example 3: padding ====

# For Example 3, take the same list as before, but remove x$group1$class2:

x <- list(
  group1 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  ),
  group2 = list(
    class1 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    ),
    class2 = list(
      height = rnorm(10, 170),
      weight = rnorm(10, 80),
      sex = sample(c("M", "F", NA), 10, TRUE)
    )
  )
)


hier2dim(x) # as indicated here, dimension 2 (i.e. columns) will have padding

# casting this to a dimensional list will resulting in padding with `NULL`:
x2 <- cast_hier2dim(x)
print(x2)
# The `NULL` values are added for padding.
# This is because all slices of the same dimension need to have the same number of elements.  
# For example, all rows need to have the same number of columns.

# one can also use custom padding:
x2 <- cast_hier2dim(x, padding = list(~ "this is padding"))
print(x2)

dimnames(x2) <- hiernames2dimnames(x)

print(x2)


# we can also use in2out = FALSE:
x2 <- cast_hier2dim(x, in2out = FALSE, padding = list(~ "this is padding"))
dimnames(x2) <- hiernames2dimnames(x, in2out = FALSE)
print(x2)


}
\seealso{
\link{broadcast_casting}, \link{cast_hier2dim} \cr
}
