% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_response.R
\name{model_get_response}
\alias{model_get_response}
\alias{model_get_response.default}
\alias{model_get_response.glm}
\alias{model_get_response.glmerMod}
\alias{model_get_response.model_fit}
\title{Get model response}
\usage{
model_get_response(model)

\method{model_get_response}{default}(model)

\method{model_get_response}{glm}(model)

\method{model_get_response}{glmerMod}(model)

\method{model_get_response}{model_fit}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
This function does not cover \code{lavaan} models (\code{NULL} is returned).
}
\examples{
lm(hp ~ mpg + factor(cyl) + disp:hp, mtcars) \%>\%
  model_get_response()

mod <- glm(
  response ~ stage * grade + trt,
  gtsummary::trial,
  family = binomial,
  contrasts = list(stage = contr.sum, grade = contr.treatment(3, 2), trt = "contr.SAS")
)
mod \%>\% model_get_response()

mod <- glm(
  Survived ~ Class * Age + Sex,
  data = Titanic \%>\% as.data.frame(),
  weights = Freq,
  family = binomial
)
mod \%>\% model_get_response()

d <- dplyr::as_tibble(Titanic) \%>\%
  dplyr::group_by(Class, Sex, Age) \%>\%
  dplyr::summarise(
    n_survived = sum(n * (Survived == "Yes")),
    n_dead = sum(n * (Survived == "No"))
  )
mod <- glm(cbind(n_survived, n_dead) ~ Class * Age + Sex, data = d, family = binomial, y = FALSE)
mod \%>\% model_get_response()
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_n}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
