% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_basic.R
\name{cc}
\alias{cc}
\title{Split up a string (with separators) into a character vector.}
\usage{
cc(..., sep = "auto")
}
\arguments{
\item{...}{Character string(s).}

\item{sep}{Pattern for separation.

Default is \code{"auto"}, including 5 common separators: , ; | \\n \\t.}
}
\value{
Character vector.
}
\description{
Split up a string (with separators) into a character vector
(whitespace around separator is trimmed).
}
\examples{
cc("a,b,c,d,e")

cc(" a , b , c , d , e ")

cc("1, 2, 3, 4, 5")

cc("A 1 , B 2 ; C 3 | D 4 \t E 5")

cc("A, B, C",
   " D | E ",
   c("F", "G"))

cc("
American
British
Chinese
")

}
