% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_post.R
\name{bs_post}
\alias{bs_post}
\title{Make a post on Bluesky Social}
\usage{
bs_post(
  text,
  images,
  images_alt,
  video,
  video_alt,
  langs,
  reply,
  quote,
  embed = TRUE,
  emoji = TRUE,
  max_tries,
  created_at = bs_created_at(),
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{text}{Text of post}

\item{images}{Character vector of paths to images to attach to post}

\item{images_alt}{Character vector of alt text for images. Must be same length as \code{images} if used.}

\item{video}{Character vector of path for up to one video to attach to post}

\item{video_alt}{Character vector, length one, of alt text for video, if used.}

\item{langs}{Character vector of languages in BCP-47 format}

\item{reply}{Character vector with link to the parent post to reply to}

\item{quote}{Character vector with link to a post to quote}

\item{embed}{Logical. Default is \code{TRUE}. Should a link card be embedded?}

\item{emoji}{Logical. Default is \code{TRUE}. Should \verb{:emoji:} style references be converted?}

\item{max_tries}{Integer, >= 2. Number of times to retry the request if the first fails.}

\item{created_at}{Character, length 1 of the form "\%Y-\%m-\%dT\%H:\%M:\%OS6Z". Time to assign to a record. Default is \code{bs_created_at()}.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of post information
}
\description{
Make a post on Bluesky Social
}
\section{Emoji parsing}{

\verb{:emoji:} parsing is not a formally supported Bluesky feature. This package
converts usages of this kind by identifying text within \code{:}s, here "\code{emoji}"
and then matches them to the \code{emoji} package's list of emoji names. All
supported emoji names and corresponding images can be seen with
\code{emoji::emoji_name}. This feature was introduced in \code{v0.2.0}.
}

\section{Embedding}{

Embedding is a feature that allows for a link card to be created when a URL
or other media to be added as a preview to the post. This feature was
introduced in \code{v0.2.0}.

Embeds are processed as follows:
\enumerate{
\item If \code{is.list(embed)}, it is assumed to be an embed object. These should be
created with \code{bs_new_embed_external()}, unless you are certain of the
structure.
\item If \code{is.character(embed)}, it is assumed to be a URL. The function will
use the open graph protocol to try to infer the embed from the URL.
\item If \code{isTRUE(embed)}, the \emph{default}, it tries to infer the embed from the text.
\item First, if a Tenor Gif link is found in the text, it will be embedded.
\item Second, if a URL is found in the text, it will be embedded. Only the first
URL found will be embedded.
\item If \code{isFALSE(embed)} or it does match an earlier condidtion, no embed is
created and the post is sent as is.
}
}

\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/post.json}{feed/post.json (2024-11-29)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_post('Test post from R CMD Check for r package `bskyr`
via @bskyr.bsky.social (https://christophertkenny.com/bskyr/)')
bs_post('Test self-reply from r package `bskyr`
via @bskyr.bsky.social (https://christophertkenny.com/bskyr/)',
  reply = 'https://bsky.app/profile/bskyr.bsky.social/post/3kexwuoyqj32g'
)
bs_post('Test quoting from r package `bskyr`
via @bskyr.bsky.social (https://christophertkenny.com/bskyr/)',
  quote = 'https://bsky.app/profile/bskyr.bsky.social/post/3kf24wd6cmb2a'
)
bs_post('Test quote and reply from r package `bskyr`
via @bskyr.bsky.social (https://christophertkenny.com/bskyr/)',
  reply = 'https://bsky.app/profile/bskyr.bsky.social/post/3kexwuoyqj32g',
  quote = 'https://bsky.app/profile/bskyr.bsky.social/post/3kf24wd6cmb2a'
)

bs_post('Test quote with :emoji: and :fire: and :confetti_ball: from r package
  `bskyr` via @bskyr.bsky.social (https://christophertkenny.com/bskyr/)')

bs_post(text = 'Testing images and aspect ratios from R',
  images = fs::path_package('bskyr', 'man/figures/logo.png'),
  images_alt = 'hexagonal logo of the R package bskyr, with the text "bskyr" on a cloud')

bs_post(text = 'testing sending videos from R',
  video = fs::path_package('bskyr', 'man/figures/pkgs.mp4'),
  video_alt = 'a carousel of package logos, all hexagonal')
\dontshow{\}) # examplesIf}
}
\concept{record}
