% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_tooltip.R
\name{bs_embed_tooltip}
\alias{bs_embed_tooltip}
\alias{use_bs_tooltip}
\title{Tooltip}
\usage{
bs_embed_tooltip(tag, title = "", placement = "top", ...)

use_bs_tooltip()
}
\arguments{
\item{tag}{\verb{htmltools::[tag][htmltools::tag]}, generally
\verb{<button/>} or \verb{<a/>}, into which to embed the tooltip}

\item{title}{character, title for the tooltip}

\item{placement}{character, placement of the tooltip with respect to \code{tag}}

\item{...}{other named arguments, passed to \code{bs_set_data()}}
}
\value{
\verb{htmltools::[tag][htmltools::tag]}, modified copy of \code{tag}
}
\description{
A tooltip can be a useful way to add a few words of explanation to a tag.
}
\details{
To activate the use of tooltips in your page, you will need to call
the \code{use_bs_tooltip()} function somewhere.

The verb \emph{embed} is used to signify that you are embedding information
into a \code{tag}. This implies that you can embed, at most, one "thing"
into a particular \code{tag}. You should not, for example, expect to embed both a tooltip
and a popover into a \code{tag}.
}
\examples{
library("htmltools")
bs_button("I'm a button") \%>\%
  bs_embed_tooltip(title = "I'm a tooltip")
}
\seealso{
\code{\link[=bs_embed_popover]{bs_embed_popover()}}, \url{https://getbootstrap.com/docs/3.3/javascript/#tooltips}
}
