% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/42_set_mh.R
\name{set_mh}
\alias{set_mh}
\title{Settings to tune a Metropolis-Hastings step}
\usage{
set_mh(adjust_burn = 0.8, acc_target = c(0.2, 0.45), acc_change = 0.01)
}
\arguments{
\item{adjust_burn}{Numeric scalar with the percentage of burn-in that should be used to tune the MH step.}

\item{acc_target}{Numeric vector with the lower and upper bound of the target acceptance rate for the MH step.}

\item{acc_change}{Numeric scalar with the percentage adjustment to the proposal scale for tuning.}
}
\value{
Returns a list with settings to tune the Metropolis-Hastings step of a Bayesian model.
}
\description{
Settings to tune a Metropolis-Hastings step
}
\examples{
set_mh(0.5, c(0.1, 0.5), .05)
}
