% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{bsm_lg}
\alias{bsm_lg}
\title{Basic Structural (Time Series) Model}
\usage{
bsm_lg(
  y,
  sd_y,
  sd_level,
  sd_slope,
  sd_seasonal,
  beta,
  xreg = NULL,
  period = frequency(y),
  a1,
  P1,
  D,
  C
)
}
\arguments{
\item{y}{Vector or a \code{\link{ts}} object of observations.}

\item{sd_y}{A fixed value or prior for the standard error of
observation equation. See \link[=uniform]{priors} for details.}

\item{sd_level}{A fixed value or a prior for the standard error
of the noise in level equation. See \link[=uniform]{priors} for details.}

\item{sd_slope}{A fixed value or a prior for the standard error
of the noise in slope equation. See \link[=uniform]{priors} for details.
If missing, the slope term is omitted from the model.}

\item{sd_seasonal}{A fixed value or a prior for the standard error
of the noise in seasonal equation. See \link[=uniform]{priors} for details.
If missing, the seasonal component is omitted from the model.}

\item{beta}{Prior for the regression coefficients.}

\item{xreg}{Matrix containing covariates.}

\item{period}{Length of the seasonal component i.e. the number of}

\item{a1}{Prior means for the initial states (level, slope, seasonals).
Defaults to vector of zeros.}

\item{P1}{Prior covariance for the initial states (level, slope, seasonals).
Default is diagonal matrix with 1000 on the diagonal.}

\item{D, C}{Intercept terms for observation and
state equations, given as a length n vector and m times n matrix respectively.}
}
\value{
Object of class \code{bsm_lg}.
}
\description{
Constructs a basic structural model with local level or local trend component
and seasonal component.
}
\examples{

prior <- uniform(0.1 * sd(log10(UKgas)), 0, 1)
model <- bsm_lg(log10(UKgas), sd_y = prior, sd_level =  prior,
  sd_slope =  prior, sd_seasonal =  prior)

mcmc_out <- run_mcmc(model, iter = 5000)
summary(expand_sample(mcmc_out, "theta"))$stat
mcmc_out$theta[which.max(mcmc_out$posterior), ]
sqrt((fit <- StructTS(log10(UKgas), type = "BSM"))$coef)[c(4, 1:3)]

}
