% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{run_mcmc.gaussian}
\alias{run_mcmc.gaussian}
\title{Bayesian Inference of Linear-Gaussian State Space Models}
\usage{
\method{run_mcmc}{gaussian}(
  model,
  iter,
  output_type = "full",
  burnin = floor(iter/2),
  thin = 1,
  gamma = 2/3,
  target_acceptance = 0.234,
  S,
  end_adaptive_phase = TRUE,
  threads = 1,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)
}
\arguments{
\item{model}{Model model.}

\item{iter}{Number of MCMC iterations.}

\item{output_type}{Type of output. Default is \code{"full"}, which returns
samples from the posterior \eqn{p(\alpha, \theta)}. Option \code{"summary"} does not simulate
states directly but computes the posterior means and variances of states using
fast Kalman smoothing. This is slightly faster, more memory efficient and
more accurate than calculations based on simulation smoother. Using option \code{"theta"} will only
return samples from the marginal posterior of the hyperparameters \eqn{\theta}.}

\item{burnin}{Length of the burn-in period which is disregarded from the
results. Defaults to \code{iter / 2}. Note that all MCMC algorithms of \code{bssm}
 used adaptive MCMC during the burn-in period in order to find good proposal.}

\item{thin}{Thinning rate. All MCMC algorithms in \code{bssm} use the jump chain
representation, and the thinning is applied to these blocks.
Defaults to 1.}

\item{gamma}{Tuning parameter for the adaptation of RAM algorithm. Must be
between 0 and 1 (not checked).}

\item{target_acceptance}{Target acceptance ratio for RAM. Defaults to 0.234.}

\item{S}{Initial value for the lower triangular matrix of RAM
algorithm, so that the covariance matrix of the Gaussian proposal
distribution is \eqn{SS'}. Note that for some parameters 
(currently the standard deviation and dispersion parameters of bsm_lg models) the sampling
is done for transformed parameters with internal_theta = log(theta).}

\item{end_adaptive_phase}{If \code{TRUE} (default), S is held fixed after the burnin period.}

\item{threads}{Number of threads for state simulation.}

\item{seed}{Seed for the random number generator.}

\item{...}{Ignored.}
}
\description{
Bayesian Inference of Linear-Gaussian State Space Models
}
\references{
Vihola, M, Helske, J, Franks, J. Importance sampling type estimators based on approximate marginal Markov chain Monte Carlo. 
Scand J Statist. 2020; 1– 38. https://doi.org/10.1111/sjos.12492
}
