% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbergm.R
\name{tbergm}
\alias{tbergm}
\title{Estimate a TERGM using Bayesian estimation}
\usage{
tbergm(formula, returndata = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{formula}{Formula for the TERGM. Model construction works like in the
\pkg{ergm} package with the same model terms etc. (for a list of terms, see
\code{help("\link[ergm]{ergm-terms}")}). The networks to be modeled on the
left-hand side of the equation must be given either as a list of network
objects with more recent networks last (i.e., chronological order) or as a
list of matrices with more recent matrices at the end. \code{dyadcov} and
\code{edgecov} terms accept time-independent covariates (as \code{network}
or \code{matrix} objects) or time-varying covariates (as a list of networks
or matrices with the same length as the list of networks to be modeled).}

\item{returndata}{Return the processed input data instead of estimating and
returning the model? In the \code{btergm} case, this will return a data
frame with the dyads of the dependent variable/network and the change
statistics for all covariates. In the \code{mtergm} case, this will return
a list object with the blockdiagonal network object for the dependent
variable and blockdiagonal matrices for all dyadic covariates and the
offset matrix for the structural zeros.}

\item{verbose}{Print details about data preprocessing and estimation
settings.}

\item{...}{Further arguments to be handed over to the
\code{\link[Bergm]{bergm}} function in the \pkg{Bergm} package.}
}
\description{
Estimate a TERGM using Bayesian estimation.
}
\details{
The \code{tbergm} function computes TERGMs by Bayesian estimation via
blockdiagonal matrices and structural zeros. It acts as a wrapper for the
\code{\link[Bergm]{bergm}} function in the \pkg{Bergm} package.
}
\references{
Caimo, Alberto and Nial Friel (2012): Bergm: Bayesian Exponential
  Random Graphs in R. \emph{Journal of Statistical Software} 61(2): 1-25.
  \doi{10.18637/jss.v061.i02}.
}
\seealso{
\code{\link{btergm}} \code{\link{mtergm}}
}
\author{
Philip Leifeld
}
