% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-environment.R
\name{btw_tool_env_describe_environment}
\alias{btw_tool_env_describe_environment}
\title{Tool: Describe an environment}
\usage{
btw_tool_env_describe_environment(items = NULL, `_intent` = "")
}
\arguments{
\item{items}{Optional. A character vector of objects in the environment to
describe.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A string describing the environment contents with \verb{#>} prefixing
each object's printed representation.
}
\description{
This tool can be used by the LLM to describe the contents of an R session,
i.e. the data frames and other objects loaded into the global environment.
This tool will only see variables that you've named and created in the
global environment, it cannot reach into package namespaces, see which
packages you have loaded, or access files on your computer.
}
\examples{
my_cars <- mtcars[mtcars$mpg > 25, ]
btw_tool_env_describe_environment("my_cars")

}
\seealso{
\code{\link[=btw_this.environment]{btw_this.environment()}}, \code{\link[=btw_tools]{btw_tools()}}

Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
