% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildGLMMadaptive}
\alias{buildGLMMadaptive}
\title{Use \code{buildmer} to fit generalized linear mixed models using \code{mixed_model} from package \code{GLMMadaptive}}
\usage{
buildGLMMadaptive(
  formula,
  data = NULL,
  family,
  buildmerControl = buildmerControl(),
  ...
)
}
\arguments{
\item{formula}{A formula specifying both fixed and random effects using \code{lme4} syntax. (Unlike \code{mixed_model}, \code{buildGLMMadaptive} does not use a separate \code{random} argument!)}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{buildmerControl}{Control arguments for buildmer --- see the general documentation under \code{\link{buildmerControl}}}

\item{...}{Additional options to be passed to \code{mixed_model}; for backward-compatibility reasons, will also accept buildmer control parameters, although those specified in \code{buildmerControl} will take precedence}
}
\description{
Use \code{buildmer} to fit generalized linear mixed models using \code{mixed_model} from package \code{GLMMadaptive}
}
\details{
The fixed and random effects are to be passed as a single formula in \emph{\code{lme4} format}. This is internally split up into the appropriate \code{fixed} and \code{random} parts.
}
\examples{
\dontshow{
if (requireNamespace('GLMMadaptive')) model <- buildGLMMadaptive(stress ~ (1|word),family=binomial,data=vowels,nAGQ=1)
}
\donttest{
# nonsensical model given these data
if (requireNamespace('GLMMadaptive')) model <- buildGLMMadaptive(stress ~ vowel + (vowel|word),
       family=binomial,data=vowels,nAGQ=1)
}
}
\seealso{
\code{\link{buildmer-package}}
}
