% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateShinyApp.R
\name{generateShinyApp}
\alias{generateShinyApp}
\title{Generate all files required for an autonomous shiny app}
\usage{
generateShinyApp(
  shiny.dir = "shiny_bulkAnalyseR",
  app.title = "Visualisation of RNA-Seq data",
  theme = "flatly",
  modality = "RNA",
  expression.matrix,
  metadata,
  organism = NA,
  org.db = NA,
  panels.default = c("Landing", "SampleSelect", "QC", "GRN", "DE", "DEplot", "DEsummary",
    "Enrichment", "GRNenrichment", "Cross", "Patterns"),
  panels.extra = tibble::tibble(name = NULL, UIfun = NULL, UIvars = NULL, serverFun =
    NULL, serverVars = NULL),
  data.extra = list(),
  packages.extra = c(),
  cis.integration = tibble::tibble(reference.expression.matrix = NULL, reference.org.db =
    NULL, reference.coord = NULL, comparison.coord = NULL, reference.table.name = NULL,
    comparison.table.name = NULL),
  trans.integration = tibble::tibble(reference.expression.matrix = NULL, reference.org.db
    = NULL, comparison.expression.matrix = NULL, comparison.org.db = NULL,
    reference.table.name = NULL, comparison.table.name = NULL),
  custom.integration = tibble::tibble(reference.expression.matrix = NULL,
    reference.org.db = NULL, comparison.table = NULL, reference.table.name = NULL,
    comparison.table.name = NULL)
)
}
\arguments{
\item{shiny.dir}{directory to store the shiny app; if a non-empty
directory with that name already exists an error is generated}

\item{app.title}{title to be displayed within the app}

\item{theme}{shiny theme to be used in the app; default is 'flatly'}

\item{modality}{name of the modality, or a vector of modalities to be
included in the app}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression; a list  (of the same
length as modality) can be provided if #' \code{length(modality) > 1}}

\item{organism}{organism name to be passed on to \code{gprofiler2::gost};
organism names are constructed by concatenating the first letter of the
name and the family name; default is NA - enrichment is not included
to ensure compatibility with datasets that have non-standard gene names;
a vector (of the same length as modality) can be provided if
\code{length(modality) > 1}}

\item{org.db}{database for annotations to transform ENSEMBL IDs to
gene names; a list of bioconductor packaged databases can be found with
\code{BiocManager::available("^org\\.")};
default in NA, in which case the row names of the expression matrix are
used directly - it is recommended to provide ENSEMBL IDs if the database
for your model organism is available;
a vector (of the same length as modality) can be provided if
\code{length(modality) > 1}}

\item{panels.default}{argument to control which of the default panels
will be included in the app; default is all, but the enrichment panel
will not appear unless organism is also supplied; note that the 'DE' panel
is required for 'DEplot', 'DEsummary', 'Enrichment', and 'GRNenrichment'; a list  (of the same
length as modality) can be provided if \code{length(modality) > 1}}

\item{panels.extra, data.extra, packages.extra}{functionality to add new
user-created panels to the app to extend functionality or change the default
behaviour of existing panels; a data frame of the modality, panel UI and
server names and default parameters should be passed to panels.extra
(see example); the names of any packages required
should be passed to the packages.extra argument; extra data should be a
single list and passed to the data.extra argument}

\item{cis.integration}{functionality to integrate extra cis-regulatory
information into GRN panel. Tibble containing names of reference expression
matrix, tables of coordinates for elements corresponding to rows of reference
expression matrix (reference.coord), tables of coordinates to compare against
reference.coord (comparison.coord) and names for comparison tables. See
vignettes for more details about inputs.}

\item{trans.integration}{functionality to integrate extra trans-regulatory
information into GRN panel. Tibble containing names of reference expression
matrix, (reference.expression.matrix), comparison expression matrix
(comparison.expression.matrix). Organism database names for each expression
matrix and names for each table are also required. See vignettes for more
details about inputs.}

\item{custom.integration}{functionality to integrate custom information
related to rows of reference expression matrix. Tibble containing names
of reference expression matrix, tables (comparison.table) with Reference_ID
and Reference_Name (matching ENSEMBL and NAME columns of reference organism
database) and Comparison_ID and Comparison_Name plus a Category column
containing extra information. Names for the reference
expression matrix and comparison table (comparison.table.name)
are also required. See vignettes for more details about inputs.}
}
\value{
The path to shiny.dir (invisibly).
}
\description{
This function creates an app.R file and all required objects
to run the app in .rda format in the target directory. A basic argument
check is performed to avoid input data problems. The app directory
is standalone and can be used on another platform, as long as bulkAnalyseR
is installed there. It is recommended to run
\code{\link{preprocessExpressionMatrix}} before this function.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))
metadata <- data.frame(
  srr = colnames(expression.matrix.preproc), 
  timepoint = rep(c("0h", "12h", "36h"), each = 2)
)
app.dir <- generateShinyApp(
  shiny.dir = paste0(tempdir(), "/shiny_Yang2019"),
  app.title = "Shiny app for the Yang 2019 data",
  modality = "RNA",
  expression.matrix = expression.matrix.preproc,
  metadata = metadata,
  organism = "mmusculus",
  org.db = "org.Mm.eg.db"
)
# runApp(app.dir)

# Example of an app with a second copy of the QC panel
app.dir.qc2 <- generateShinyApp(
  shiny.dir = paste0(tempdir(), "/shiny_Yang2019_QC2"),
  app.title = "Shiny app for the Yang 2019 data",
  expression.matrix = expression.matrix.preproc,
  metadata = metadata,
  organism = "mmusculus",
  org.db = "org.Mm.eg.db",
  panels.extra = tibble::tibble(
    name = "RNA2",
    UIfun = "modalityPanelUI", 
    UIvars = "'RNA2', metadata[[1]], NA, 'QC'", 
    serverFun = "modalityPanelServer", 
    serverVars = "'RNA2', expression.matrix[[1]], metadata[[1]], anno[[1]], NA, 'QC'"
  )
)
# runApp(app.dir.qc2)

# clean up tempdir
unlink(paste0(normalizePath(tempdir()), "/", dir(tempdir())), recursive = TRUE)
}
