\name{helpers}
\alias{predictive.density}
\alias{predictive.draws}
\title{
Helper Functions to Access BVAR Forecast Distributions
}
\description{
Functions to extract a univariate posterior predictive distribution from a model fit generated by \code{\link{bvar.sv.tvp}}.
}
\usage{
predictive.density(fit, v = 1, h = 1, cdf = FALSE)
predictive.draws(fit, v = 1, h = 1)
}
\arguments{
  \item{fit}{List, model fit generated by \code{\link{bvar.sv.tvp}}}
  \item{v}{Index for variable of interest. \emph{Must be in line with the specification of \code{fit}}.}
  \item{h}{Index for forecast horizon of interest. \emph{Must be in line with the specification of \code{fit}}.}
  \item{cdf}{Set to TRUE to return cumulative distribution function, set to FALSE to return probability density function}
}
\value{
 \code{\link{predictive.density}} returns a function \code{f(z)}, which yields the value(s) of the predictive density at point(s) \code{z}. This function exploits conditional normality of the model, given the posterior draws of the parameters.
 
\code{\link{predictive.draws}} returns a vector of MCMC draws.
 
Both outputs should be closely in line with each other (apart from a small amount of sampling noise), see the link below for details.
}
\author{
Fabian Krueger
}
\examples{
\dontrun{

# Load US macro data
data(usmacro)

# Estimate trivariate BVAR using default settings
set.seed(5813)
bv <- bvar.sv.tvp(usmacro)

# Construct predictive density function for the second variable (inflation), one period ahead
f <- predictive.density(bv, v = 2, h = 1)

# Plot the density for a grid of values
grid <- seq(-2, 5, by = 0.05)
plot(x = grid, y = f(grid), type = "l")

# Cross-check: Extract MCMC sample for the same variable and horizon
smp <- predictive.draws(bv, v = 2, h = 1)

# Add density estimate to plot
lines(density(smp), col = "green")

}
}
\seealso{For examples and background, see the accompanying pdf file hosted at \url{https://sites.google.com/site/fk83research/code}.}

\keyword{helpers}