% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvhar-sv.R, R/print-bvharsp.R
\name{bvhar_sv}
\alias{bvhar_sv}
\alias{print.bvharsv}
\alias{knit_print.bvharsv}
\title{Fitting Bayesian VHAR-SV}
\usage{
bvhar_sv(
  y,
  har = c(5, 22),
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvhar(),
  sv_spec = set_sv(),
  intercept = set_intercept(),
  include_mean = TRUE,
  minnesota = c("longrun", "short", "no"),
  save_init = FALSE,
  convergence = NULL,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvharsv}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvharsv}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVHAR model specification by \code{\link[=set_bvhar]{set_bvhar()}} (default) \code{\link[=set_weight_bvhar]{set_weight_bvhar()}}, \code{\link[=set_ssvs]{set_ssvs()}}, or \code{\link[=set_horseshoe]{set_horseshoe()}}.}

\item{sv_spec}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SV specification by \code{\link[=set_sv]{set_sv()}}.}

\item{intercept}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Prior for the constant term by \code{\link[=set_intercept]{set_intercept()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). Two type: \code{short} type and \code{longrun} (default) type.
You can also set \code{no}.}

\item{save_init}{Save every record starting from the initial values (\code{TRUE}).
By default, exclude the initial values in the record (\code{FALSE}), even when \code{num_burn = 0} and \code{thinning = 1}.
If \code{num_burn > 0} or \code{thinning != 1}, this option is ignored.}

\item{convergence}{Convergence threshold for rhat < convergence. By default, \code{NULL} which means no warning.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{Number of threads}

\item{x}{\code{bvarsv} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvhar_sv()} returns an object named \code{bvharsv} \link{class}. It is a list with the following components:
\describe{
\item{coefficients}{Posterior mean of coefficients.}
\item{chol_posterior}{Posterior mean of contemporaneous effects.}
\item{param}{Every set of MCMC trace.}
\item{param_names}{Name of every parameter.}
\item{group}{Indicators for group.}
\item{num_group}{Number of groups.}
\item{df}{Numer of Coefficients: \verb{3m + 1} or \verb{3m}}
\item{p}{3 (The number of terms. It contains this element for usage in other functions.)}
\item{week}{Order for weekly term}
\item{month}{Order for monthly term}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \code{VHAR_SSVS_SV}, \code{VHAR_Horseshoe_SV}, or \code{VHAR_minnesota-part_SV}}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{spec}{Coefficients prior specification}
\item{sv}{log volatility prior specification}
\item{init}{Initial values}
\item{intercept}{Intercept prior specification}
\item{chain}{The numer of chains}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{HARtrans}{VHAR linear transformation matrix}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
If it is SSVS or Horseshoe:
\describe{
\item{pip}{Posterior inclusion probabilities.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function fits VHAR-SV.
It can have Minnesota, SSVS, and Horseshoe prior.
This function is deprecated. Use \code{\link[=vhar_bayes]{vhar_bayes()}} with \code{cov_spec = set_sv()} option.
}
\details{
Cholesky stochastic volatility modeling for VHAR based on
\deqn{\Sigma_t = L^T D_t^{-1} L}
}
\references{
Kim, Y. G., and Baek, C. (n.d.). Working paper.
}
