% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cNORM.R
\name{cnorm}
\alias{cnorm}
\title{Continuous Norming}
\usage{
cnorm(
  raw = NULL,
  group = NULL,
  age = NULL,
  width = NA,
  weights = NULL,
  scale = "T",
  method = 4,
  descend = FALSE,
  k = 4,
  terms = 0,
  R2 = NULL
)
}
\arguments{
\item{raw}{Numeric vector of raw scores}

\item{group}{Numeric vector of grouping variable, e. g. grade}

\item{age}{Numeric vector with chronological age, please additionally specify width of window}

\item{width}{Size of the moving window in case an age vector is used}

\item{weights}{Vector or variable name in the dataset with weights to compensate imbalances due to insufficient norm
data stratification. All weights have to be numerical and positive. The code to compute weighted percentiles originates from the
Hmisc package (functions) wtd.rank and wtd.table) and is provided by the courtesy of Frank Harrell. Please note, that this
feature is currently EXPERIMENTAL!}

\item{scale}{type of norm scale, either T (default), IQ, z or percentile (= no
transformation); a double vector with the mean and standard deviation can as well,
be provided f. e. c(10, 3) for Wechsler scale index points}

\item{method}{Ranking method in case of bindings, please provide an index,
choosing from the following methods: 1 = Blom (1958), 2 = Tukey (1949),
3 = Van der Warden (1952), 4 = Rankit (default), 5 = Levenbach (1953),
6 = Filliben (1975), 7 = Yu & Huang (2001)}

\item{descend}{ranking order (default descent = FALSE): inverses the
ranking order with higher raw scores getting lower norm scores; relevant
for example when norming error scores, where lower scores mean higher
performance}

\item{k}{The power constant. Higher values result in more detailed approximations
but have the danger of over-fit (default = 4, max = 6)}

\item{terms}{Selection criterion for model building. The best fitting model with
this number of terms is used}

\item{R2}{Adjusted R square as a stopping criterion for the model building
(default R2 = 0.99)}
}
\value{
cnorm object including the ranked raw data and the regression model
}
\description{
Conducts continuous norming in one step and returns an object including ranked raw data and the continuous norming
model. Please consult the function description ' of 'rankByGroup', 'rankBySlidingWindow' and 'bestModel' for specifics
of the steps in the data preparation and modelling process. In addition to the raw scores, either provide
\itemize{
 \item{a numeric vector for the grouping information (group)}
 \item{a numeric vector for both grouping and age (group, age)}
 \item{a numeric age vector and the width of the sliding window (age, width)}
}
for the ranking of the raw scores. You can
adjust the grade of smoothing of the regression modell by setting the k and terms parameter. In general,
increasing k to more than 4 and the number of terms lead to a higher fit, while lower values lead to more
smoothing.
}
\examples{

# Using this function with the example dataset 'elfe'
cnorm.elfe <- cnorm(raw = elfe$raw, group = elfe$group)

# return norm tables including 90\% confidence intervals for a
# test with a reliability of r = .85; table are set to mean of quartal
# in grade 3 (children completed 2 years of schooling)
normTable(c(2.125, 2.375, 2.625, 2.875), cnorm.elfe, CI = .90, reliability = .95)

# ... or instead of raw scores for norm scores, the other way round
rawTable(c(2.125, 2.375, 2.625, 2.875), cnorm.elfe, CI = .90, reliability = .95)

}
\references{
\enumerate{
  \item Gary, S. & Lenhard, W. (2021). In norming we trust. Diagnostica.
  \item Harrel, F. (2020). Hmisc: Harrell Miscellaneous (v. 4.4-1). available https://CRAN.R-project.org/package=Hmisc
  (code for weighted ranking adapted from wtd.rank & wtd.table by courtesy of Frank Harrell)
  \item Lenhard, A., Lenhard, W., Suggate, S. & Segerer, R. (2016). A continuous solution to the norming problem. Assessment, Online first, 1-14. doi:10.1177/1073191116656437
  \item Lenhard, A., Lenhard, W., Gary, S. (2018). Continuous Norming (cNORM). The Comprehensive R Network, Package cNORM, available: https://CRAN.R-project.org/package=cNORM
  \item Lenhard, A., Lenhard, W., Gary, S. (2019). Continuous norming of psychometric tests: A simulation study of parametric and semi-parametric approaches. PLoS ONE, 14(9),  e0222279. doi:10.1371/journal.pone.0222279
  \item Lenhard, W., & Lenhard, A. (2020). Improvement of Norm Score Quality via Regression-Based Continuous Norming. Educational and Psychological Measurement(Online First), 1-33. https://doi.org/10.1177/0013164420928457
}
}
\seealso{
rankByGroup, rankBySlidingWindow, computePowers, bestModel
}
