% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shash.R
\name{log_likelihood_shash}
\alias{log_likelihood_shash}
\title{Calculate the negative log-likelihood for a ShaSh regression model}
\usage{
log_likelihood_shash(
  params,
  X_mu,
  X_sigma,
  X_epsilon,
  X_delta = NULL,
  y,
  weights = NULL,
  fixed_delta = NULL
)
}
\arguments{
\item{params}{A numeric vector containing all model parameters}

\item{X_mu}{Design matrix for location parameter}

\item{X_sigma}{Design matrix for scale parameter}

\item{X_epsilon}{Design matrix for skewness parameter}

\item{X_delta}{Design matrix for tails}

\item{y}{Response vector}

\item{weights}{Observation weights}

\item{fixed_delta}{If not NULL, the delta parameter is fixed to this value}
}
\value{
The negative log-likelihood of the model
}
\description{
This function computes the negative log-likelihood for a Sinh-Arcsinh regression model
where the location, scale, and skewness parameters are modeled as functions of predictors.
}
\keyword{internal}
