% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cOde.R
\name{setForcings}
\alias{setForcings}
\title{Generate interpolation spline for the forcings and write into list of matrices}
\usage{
setForcings(func, forcings)
}
\arguments{
\item{func}{result from funC()}

\item{forcings}{data.frame with columns name (factor), time (numeric) and value (numeric)}
}
\value{
list of matrices with time points and values assigned to the forcings interface of deSolve
}
\description{
Generate interpolation spline for the forcings and write into list of matrices
}
\details{
Splines are generated for each name in forcings and both, function value and first
derivative are evaluated at the time points of the data frame.
}
\examples{
f <- c(x = "-k*x + a - b")
func <- funC(f, forcings = c("a", "b"))
forcData <- rbind(
  data.frame(name = "a", time = c(0, 1, 10), value = c(0, 5, 2)),
  data.frame(name = "b", time = c(0, 5, 10), value = c(1, 3, 6)))
forc <- setForcings(func, forcData) 
}

