% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{fit_measures}
\alias{fit_measures}
\alias{calculateChiSquare}
\alias{calculateChiSquareDf}
\alias{calculateCFI}
\alias{calculateGFI}
\alias{calculateCN}
\alias{calculateIFI}
\alias{calculateNFI}
\alias{calculateNNFI}
\alias{calculateRMSEA}
\alias{calculateRMSTheta}
\alias{calculateSRMR}
\title{Model fit measures}
\usage{
calculateChiSquare(.object)

calculateChiSquareDf(.object)

calculateCFI(.object)

calculateGFI(.object, .type_gfi = c("ML", "GLS", "ULS"), ...)

calculateCN(.object, .alpha = 0.05, ...)

calculateIFI(.object)

calculateNFI(.object)

calculateNNFI(.object)

calculateRMSEA(.object)

calculateRMSTheta(.object)

calculateSRMR(
  .object = NULL,
  .matrix1 = NULL,
  .matrix2 = NULL,
  .saturated = FALSE,
  ...
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.type_gfi}{Character string. Which fitting function should the GFI be based
on? One of \emph{"ML"} for the maximum likelihood fitting function, \emph{"GLS"} for
the generalized least squares fitting function or \emph{"ULS"} for the
unweighted least squares fitting function (same as the squared Euclidian distance).
Defaults to \emph{"ML"}.}

\item{...}{Ignored.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.matrix1}{A \code{matrix} to compare.}

\item{.matrix2}{A \code{matrix} to compare.}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}
}
\value{
A single numeric value.
}
\description{
Calculate fit measures.
}
\details{
See the \href{https://m-e-rademaker.github.io/cSEM/articles/Using-assess.html#fit_indices}{Fit indices}
section of the \href{https://m-e-rademaker.github.io/cSEM/index.html}{cSEM website}
for details on the implementation.
}
\section{Functions}{
\itemize{
\item \code{calculateChiSquare}: The chi square statistic.

\item \code{calculateChiSquareDf}: The ChiSquare statistic divided by its degrees of freedom.

\item \code{calculateCFI}: The comparative fit index (CFI).

\item \code{calculateGFI}: The goodness of fit index (GFI).

\item \code{calculateCN}: The Hoelter index alias Hoelter's (critical) N (CN).

\item \code{calculateIFI}: The incremental fit index (IFI).

\item \code{calculateNFI}: The normed fit index (NFI).

\item \code{calculateNNFI}: The non-normed fit index (NNFI). Also called the Tucker-Lewis index (TLI).

\item \code{calculateRMSEA}: The root mean square error of approximation (RMSEA).

\item \code{calculateRMSTheta}: The root mean squared residual covariance matrix of the outer model residuals (RMS theta).

\item \code{calculateSRMR}: The standardized root mean square residual (SRMR).
}}

