% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineclassesandfunctions.R
\name{rearrange_old}
\alias{rearrange_old}
\title{Old and rubbish algorithm to rearrange bootstrap axes by comparing to sample axes}
\usage{
rearrange_old(RS, RB, CS, CB, r)
}
\arguments{
\item{RS}{Sample axes for row points (as columns)}

\item{RB}{Bootstrap axes for row points (as columns)}

\item{CS}{Sample axes for column points (as columns)}

\item{CB}{Bootstrap axes for column points (as columns)}

\item{r}{Rank of the bootstrap matrix}
}
\value{
list containing: \cr
  T = matrix to rearrange xB so it is equivalent to xS, i.e. xS <- xB * T \cr
  numre = number of axes checked for rearranging = min(r,maxrearrange)\cr
  match = assign$objval from the Hungarian algorithm\cr
  same = flag for whether there was no reordering of axes (but may have been reflection)
}
\description{
\code{rearrange_old} compares one set of axes for row points and column points (from the bootstrap
  data matrix) to another (from the sample data matrix) by looking at all possible
  reorderings and reflections (only) of the bootstrap axes and picking the one which
  best matches the sample axes.
}
\details{
This is only intended for internal use by the \code{\link{cabootcrs}} function, and only for
simple CA if for some reason the lpSolve package is unavailable.

It has not been used with MCA, and so will almost certainly not work properly in that case.

Finds the rearrangement of columns of RB and CB to maximise match = tr( abs(RS'*RB + CS'*CB) )

Goes through all possible orderings and so is painfully slow.
}
\examples{
# Not intended for direct call by users

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}},  \code{\link{rearrange}}
}
