% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{gradient}
\alias{gradient}
\alias{\%gradient\%}
\title{Numerical and Symbolic Gradient}
\usage{
gradient(f, var, accuracy = 2, stepsize = NULL, coordinates = "cartesian")

f \%gradient\% var
}
\arguments{
\item{f}{function, expression or character array.}

\item{var}{character vector, giving the variable names with respect to which derivatives will be computed. If a named vector is provided, derivatives will be computed at that point.}

\item{accuracy}{accuracy degree for numerical derivatives.}

\item{stepsize}{finite differences stepsize for numerical derivatives. Auto-optimized by default.}

\item{coordinates}{coordinate system to use. One of: \code{cartesian}, \code{polar}, \code{spherical}, \code{cylindrical}, \code{parabolic}, \code{parabolic-cylindrical} or a character vector of scale factors for each varibale.}
}
\value{
gradient or jacobian array.
}
\description{
Computes the gradient or jacobian of functions, expressions and characters.
}
\section{Functions}{
\itemize{
\item \code{gradient}: arbitrary coordinate system

\item \code{\%gradient\%}: cartesian coordinates
}}

\examples{
# gradient with respect to x
gradient(f = "sin(x)", var = "x")
"sin(x)" \%gradient\% "x"

# gradient with respect to x and evaluate in x = 0
gradient(f = "sin(x)", var = c("x" = 0))
"sin(x)" \%gradient\% c(x=0)

# gradient with respect to (x,y)
gradient(f = "y*sin(x)", var = c("x","y"))
"y*sin(x)" \%gradient\% c("x","y")

# jacobian with respect to (x,y)
f <- c("y*sin(x)", "x*cos(y)")
gradient(f = f, var = c("x","y"))
f \%gradient\% c("x","y")

# jacobian with respect to (x,y) and evaluate in (x = 0, y = 0)
f <- c(function(x, y) y*sin(x), function(x, y) x*cos(y))
gradient(f = f, var = c(x=0,y=0))
f \%gradient\% c(x=0,y=0)

# gradient in spherical coordinates
gradient('r*theta*phi', var = c('r','theta','phi'), coordinates = 'spherical')

# numerical gradient in spherical coordinates
f <- function(r, theta, phi) r*theta*phi
gradient(f, var = c('r'=1, 'theta'=pi/4, 'phi'=pi/4), coordinates = 'spherical')

}
