% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranking.R
\name{ranking}
\alias{ranking}
\title{ranking}
\usage{
ranking(r, b)
}
\arguments{
\item{r}{is the RasterLayer to compare to the climatology.}

\item{b}{RasterBrick/Stack containing the historical observations or a proxy
(typically a reanalysis) that is used to derive the climatological
information.}
}
\value{
The function returns a RasterLayer with extent, resolution and
land-sea mask matching those of \code{r}. Values are the percentiles of
occurrence of the values.
}
\description{
The ranking is applied to a forecast map \code{r} and provides
percentiles of occurrence of the values based on a given climatology
(see \code{b}).
}
\details{
The objects \code{r} and \code{b} should be comparable: same
resolution and extent.
More information on ranking is available here:
https://bit.ly/2Qvekz4. To estimate fire climatology one can use hindcast or
reanalysis data. Examples of the latter are available from Zenodo:
https://zenodo.org/communities/wildfire.
}
\examples{
\dontrun{
  # Generate dummy RasterLayer
  r <- raster(nrows = 1, ncols = 1,
              xmn = 0, xmx = 360, ymn = -90, ymx = 90, vals = 0.3)
  names(r) <- as.Date("2018-01-01")
  # Generate dummy RasterBrick
  b <- raster::brick(lapply(1:(365 * 3),
                  function(i) raster::setValues(r, runif(raster::ncell(r)))))
  names(b) <- seq.Date(from = as.Date("1993-01-01"),
                       to = as.Date("1995-12-31"),
                       by = "day")
  # Compute ranking
  x <- ranking(r, b)

  # This plots nicely using rasterVis::levelplot(), see example on GWIS
  # (\url{https://gwis.jrc.ec.europa.eu}
  rasterVis::levelplot(x, col.regions = c("green", "yellow", "salmon",
                                          "orange", "red", "black"))
}

}
