% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use-diary.R
\name{use_diary}
\alias{use_diary}
\title{Create a new template data diary}
\usage{
use_diary(
  st,
  type,
  author,
  path = "state/{st}/{type}/docs/{st}_{type}_diary.Rmd",
  auto = FALSE
)
}
\arguments{
\item{st}{The USPS state abbreviation. State data only, no federal agencies.}

\item{type}{The type of data, one of "contribs", "expends", "lobby",
"contracts", "salary", or "voters".}

\item{author}{The author name of the new diary.}

\item{path}{The file path, relative to your working directory, where the
diary file will be created. If you use \code{NA}, then the lines of the diary
will be returned as a character vector. If you specify a character string
file path that contains directories that do not exist then they will be
created. By default, the path creates the diary in a directory that is
expected by the \href{https://github.com/irworkshop/accountability_datacleaning}{Accountability Project GitHub repository}.}

\item{auto}{Must be set to \code{TRUE} for the diary to be created and opened.}
}
\value{
The file path of new diary, invisibly.
}
\description{
Take the arguments supplied and put them into the appropriate places in a
new template diary. Write the new template diary in the supplied directory.
}
\examples{
use_diary("VT", "contribs", "Kiernan Nicholls", NA, auto = FALSE)
use_diary("DC", "expends", "Kiernan Nicholls", tempfile(), auto = FALSE)
}
