% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_settings.R
\name{set_cancensus_api_key}
\alias{set_cancensus_api_key}
\title{Set Censusmapper API key}
\usage{
set_cancensus_api_key(key, overwrite = FALSE, install = FALSE)
}
\arguments{
\item{key}{a Censusmapper API key. For more information on keys see the \href{https://mountainmath.github.io/cancensus/index.html#api-key}{API key section}}

\item{overwrite}{Option to overwrite any existing Censusmapper keys already stored locally.}

\item{install}{Option to install permanently for use across sessions.}
}
\description{
Cancensus requires a free Censusmapper API key to retrieve data. This function helps set the key for either the duration of the session (default) or permanently for use across sessions.
}
\examples{
\dontrun{
set_cancensus_api_key("YOUR_CM_API_KEY")

# This will set the key permanently until overwritten again
set_cancensus_api_key("YOUR_CM_API_KEY", install = TRUE)
}
}
