% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pairscan.R
\name{plot_pairscan}
\alias{plot_pairscan}
\title{Plot the result of the pairwise scan}
\usage{
plot_pairscan(
  data_obj,
  pairscan_obj,
  phenotype = NULL,
  standardized = FALSE,
  show_marker_labels = FALSE,
  show_chr = TRUE,
  label_chr = TRUE,
  show_alleles = TRUE,
  allele_labels = NULL,
  pos_col = "brown",
  neg_col = "blue",
  color_scheme = c("DO/CC", "other"),
  pdf_label = "Pairscan.Regression.pdf"
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{pairscan_obj}{a pairscan object from \code{\link{pairscan}}}

\item{phenotype}{The names of the phenotypes to be plotted. If NULL,
all phenotypes are plotted.}

\item{standardized}{If TRUE, the standardized effects are plotted.
IF FALSE, the effect sizes are plotted.}

\item{show_marker_labels}{If TRUE marker labels are plotted along the
axes. If FALSE, they are omitted.}

\item{show_chr}{If TRUE, the chromosome boundaries are shown}

\item{label_chr}{If TRUE, the chromosomes are labeled}

\item{show_alleles}{If TRUE, the allele of each marker is indicated by color.}

\item{allele_labels}{Labels for the alleles if other than those stored in the
data object.}

\item{pos_col}{The color to use for positive main effects and interactions
must be one of "green", "purple", "red", "orange", "blue", "brown", "yellow", "gray"
see \code{\link{get_color}}}

\item{neg_col}{The color to use for negative main effects and interactions
takes the same values as pos_col.}

\item{color_scheme}{either "DO/CC" or "other". "DO/CC" uses the official "DO/CC"
colors for the DO/CC alleles  
\url{http://www.csbio.unc.edu/CCstatus/index.py?run=AvailableLines.information}
"other" uses an unrelated color palette for multiple alleles.}

\item{pdf_label}{Label for the resulting file. Defaults to "Pairscan.Regression.pdf"
if plotting to pdf, "Pairscan.Regression.jpg" otherwise.}
}
\value{
Plots to a pdf
}
\description{
This function plots the results of the pairwise scan.
It plots a matrix of the the interactions between all 
pairs of markers.
}
