% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_behaviour.R
\name{validate_steps}
\alias{validate_steps}
\title{Check whether daily steps as measured by a pedometer are valid.}
\usage{
validate_steps(steps = NA, wear_time = NA)
}
\arguments{
\item{steps}{A numeric (integer) vector representing the steps taken on a given day (valid values are between 1000 and 30000).}

\item{wear_time}{A numeric vector representing the duration of time (in decimal hours) that a pedometer was worn on a given day (valid values are >= 10.0
hours).}
}
\value{
Returns the \code{steps} argument (if valid) or NA (if not valid).
}
\description{
This function checks whether daily steps as measured by a pedometer are valid. The variables from this function are used to compute \code{step_average} and
the step score (\code{step_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}} and \code{\link[=validate_number]{validate_number()}}.
}
\examples{
validate_steps(
  steps = c(5400, 11001, 999, 31000, 8796),
  wear_time = c(10.1, 12.6, 10.2, 10.9, 9.5)
)

# [1]  5400 11001    NA    NA    NA

}
