% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_sample_animals.R
\docType{data}
\name{cluster_sample_animals}
\alias{cluster_sample_animals}
\title{Owned animal data from a two-stage cluster sample}
\format{A data frame with 1052 observations and 16 variables:
#' \describe{
  \item{track_id}{Census track ID from Santos, Brazil.}
  \item{hh_id}{Household ID.}
  \item{name}{Animal's name.}
  \item{species}{Animal's species.}
  \item{sex}{Animal's sex.}
  \item{age}{Animal's age. An age equal to 0 means that the animal had less than 1 year.}
  \item{sterilized}{Animal's reproductive status.}
  \item{sterilized_last_year}{For sterilized animals, indicates if the animal was sterilized in the previous 12 months.}
  \item{free_roaming}{Indicates if the animal had access to the street without supervision.}
  \item{acquisition}{Way of acquisition}
  \item{acquired_last_year}{Indicates if the animal was acquired in the previous 12 months.}
  \item{acquired_sterilized}{Indicates if the animal was sterilized when acquired.}
  \item{acquisition_city}{City of acquisition.}
  \item{acquisition_state}{State of acquisition.}
  \item{turnover_last_year}{Indicates if the animal was acquired in the 12 months following the lost of another .}
  \item{litter_size_last_year}{Litter size if the bitch/quenn had the litter in the previous 12 months.}
}}
\usage{
cluster_sample_animals
}
\description{
Owned animal hypothetical data from a two-stage cluster sample.
}
\keyword{datasets}
