% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin-alg.R
\name{generic-matrices}
\alias{generic-matrices}
\alias{vector_sym}
\alias{matrix_sym}
\alias{matrix_sym_diag}
\alias{matrix_sym_symmetric}
\title{Generate generic vectors and matrices}
\usage{
vector_sym(n, entry = "v")

matrix_sym(nrow, ncol, entry = "v")

matrix_sym_diag(nrow, entry = "v")

matrix_sym_symmetric(nrow, entry = "v")
}
\arguments{
\item{n}{Length of vector}

\item{entry}{The symbolic name of each entry.}

\item{nrow, ncol}{Number of rows and columns}
}
\description{
Generate generic vectors and matrices.
}
\examples{
if (has_sympy()) {
  vector_sym(4, "b")
  matrix_sym(3, 2, "a")
  matrix_sym_diag(4, "s")
  matrix_sym_symmetric(4, "s")
}

}
\concept{linalg}
