% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere.R
\name{sphere}
\alias{sphere}
\title{Generate Coordinates for a Sphere}
\usage{
sphere(radius, resolution, num_noise, min_n, max_n)
}
\arguments{
\item{radius}{The radius of the sphere.}

\item{resolution}{The number of points used to approximate the surface of the sphere.}

\item{num_noise}{The number of additional noise dimensions to add to the coordinates.}

\item{min_n}{The minimum value for the random noise added to the coordinates.}

\item{max_n}{The maximum value for the random noise added to the coordinates.}
}
\value{
A matrix containing the Cartesian coordinates of the points on the sphere.
}
\description{
This function generates the coordinates for a sphere in three-dimensional space.
}
\examples{
# Generate coordinates for a sphere with radius 1 and resolution 20
set.seed(20240412)
sphere(
  radius = 1, resolution = 20, num_noise = 3, min_n = -0.05,
  max_n = 0.05
)

}
