% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_complex.R
\name{ard_complex}
\alias{ard_complex}
\title{Complex ARD Summaries}
\usage{
ard_complex(
  data,
  variables,
  by = dplyr::group_vars(data),
  strata = NULL,
  statistic,
  fmt_fn = NULL,
  stat_label = everything() ~ default_stat_labels()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Default is \code{everything()}.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to tabulate by/stratify by for summary statistic
calculation. Arguments are similar, but with an important distinction:

\code{by}: results are calculated for \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are calculated for \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
The form of the statistics argument is identical to \code{ard_continuous(statistic)}
argument, except the summary function \emph{must} accept the following arguments:
\itemize{
\item \code{x}: a vector
\item \code{data}: the data frame that has been subset such that the \code{by}/\code{strata} columns
and rows in which \code{"variable"} is \code{NA} have been removed.
\item \code{data_full}: the full data frame
\item \code{by}: character vector of the \code{by} variables
\item \code{strata}: character vector of the \code{strata} variables
It is unlikely any one function will need \emph{all} of the above elements,
and it's recommended the function passed accepts \code{...} so that any unused
arguments will be properly ignored. The \code{...} also allows this function
to perhaps be updated in the future with more passed arguments. For example,
if one needs a second variable from the data frame, the function inputs
may look like: \code{foo(x, data, ...)}
}}

\item{fmt_fn}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character))}.}

\item{stat_label}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(mean = "Mean", sd = "SD")} or
\code{everything() ~ list(mean ~ "Mean", sd ~ "SD")}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
Function is similar to \code{\link[=ard_continuous]{ard_continuous()}}, but allows for more complex
summaries. While \code{ard_continuous(statistic)} only allows for a univariable
function, \code{ard_complex(statistic)} can handle more complex data summaries.
}
\examples{
# example how to mimic behavior of `ard_continuous()`
ard_complex(
  ADSL,
  by = "ARM",
  variables = "AGE",
  statistic = list(AGE = list(mean = \(x, ...) mean(x)))
)

# return the grand mean and the mean within the `by` group
grand_mean <- function(data, data_full, variable, ...) {
  list(
    mean = mean(data[[variable]], na.rm = TRUE),
    grand_mean = mean(data_full[[variable]], na.rm = TRUE)
  )
}

ADSL |>
  dplyr::group_by(ARM) |>
  ard_complex(
    variables = "AGE",
    statistic = list(AGE = list(means = grand_mean))
  )
}
