% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pkg_installed.R
\name{check_pkg_installed}
\alias{check_pkg_installed}
\alias{is_pkg_installed}
\alias{get_pkg_dependencies}
\alias{get_min_version_required}
\title{Check Package Installation}
\usage{
check_pkg_installed(pkg, reference_pkg = "cards", call = parent.frame())

is_pkg_installed(pkg, reference_pkg = "cards", call = parent.frame())

get_pkg_dependencies(reference_pkg = "cards", lib.loc = NULL)

get_min_version_required(pkg, reference_pkg = "cards", lib.loc = NULL)
}
\arguments{
\item{pkg}{(\code{string})\cr
name of required package}

\item{reference_pkg}{(\code{string})\cr
name of the package the function will search for a minimum required version from.}

\item{call}{(\code{environment})\cr
frame for error messaging. Default is \code{\link[=parent.frame]{parent.frame()}}.}

\item{lib.loc}{(\code{path})\cr
location of \code{R} library trees to search through, see \code{\link[utils:packageDescription]{utils::packageDescription()}}.}
}
\value{
\code{check_pkg_installed()} returns a logical or error, \code{get_min_version_required()}
returns \code{NULL} or a string with the minimum version required, \code{get_pkg_dependencies()}
returns a tibble.
}
\description{
\itemize{
\item \code{check_pkg_installed()}: checks whether a package is installed and
returns an error or \code{FALSE} if not available. If a package search is provided,
the function will check whether a minimum version of a package is required.
\item \code{get_pkg_dependencies()} returns a tibble with all
dependencies of a specific package.
\item \code{get_min_version_required()} will return, if any, the minimum version
of \code{pkg} required by \code{reference_pkg}, \code{NULL} if no minimum version required.
}
}
\examples{
check_pkg_installed("dplyr")

is_pkg_installed("dplyr")

get_pkg_dependencies()

get_min_version_required("dplyr")
}
