% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_for_ard.R
\name{nest_for_ard}
\alias{nest_for_ard}
\title{ARD Nesting}
\usage{
nest_for_ard(
  data,
  by = NULL,
  strata = NULL,
  key = "data",
  rename_columns = TRUE,
  list_columns = TRUE
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{by, strata}{(\code{character})\cr
columns to nest by/stratify by. Arguments are similar,
but with an important distinction:

\code{by}: data frame is nested by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: data frame is nested by \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{key}{(\code{string})\cr
the name of the new column with the nested data frame. Default is \code{"data"}.}

\item{rename_columns}{(\code{logical})\cr
logical indicating whether to rename the \code{by} and \code{strata} variables.
Default is \code{TRUE}.}

\item{list_columns}{(\code{logical})\cr
logical indicating whether to put levels of \code{by} and
\code{strata} columns in a list. Default is \code{TRUE}.}
}
\value{
a nested tibble
}
\description{
This function is similar to \code{\link[tidyr:nest]{tidyr::nest()}}, except that it retains
rows for unobserved combinations (and unobserved factor levels) of by
variables, and unobserved combinations of stratifying variables.

The levels are wrapped in lists so they can be stacked with other types
of different classes.
}
\examples{
nest_for_ard(
  data =
    ADAE |>
      dplyr::left_join(ADSL[c("USUBJID", "ARM")], by = "USUBJID") |>
      dplyr::filter(AOCCSFL \%in\% "Y"),
  by = "ARM",
  strata = "AESOC"
)
}
