% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretEnsemble.R
\name{plot.caretEnsemble}
\alias{plot.caretEnsemble}
\title{Plot Diagnostics for an caretEnsemble Object}
\usage{
\method{plot}{caretEnsemble}(x, ...)
}
\arguments{
\item{x}{a \code{caretEnsemble} object}

\item{...}{additional arguments to pass to plot}
}
\value{
A plot
}
\description{
This function makes a short plot of the performance of the component
models of a \code{caretEnsemble} object on the AUC or RMSE metric
}
\examples{
\dontrun{
set.seed(42)
models <- caretList(iris[1:50,1:2], iris[1:50,3], methodList=c("glm", "rpart"))
ens <- caretEnsemble(models)
plot(ens)
}
}

