% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowdist.R
\name{flowdist}
\alias{flowdist}
\title{Compute continous distance matrix from geographical background}
\usage{
flowdist(tab, dist.method, result)
}
\arguments{
\item{tab}{the input flow dataset.}

\item{dist.method}{euclidian calculation}

\item{result}{take the vallue "flowdist" or "dist" allows to parameter the resulting distance dataset (flows filtered by a distance criterion or not)}
}
\value{
(1) A flowdata set with continuous euclidian distances calculations, see dist.method parameter

(2) A flowdata set with movement from euclidian distances calculations.

(3) A flowmap filtered by a global distance criterion.
}
\description{
From a geographical background computes (and threshold) a distance matrix.
}
\details{
-- result = "dist" is the resulting tab of the distance\cr
-- result = "flowdist" with all the calculated parameters
}
\examples{
library(cartograflow)
data(flowdata)
bkg<- system.file("shape/MGP_TER.shp", package="cartograflow",
                  lib.loc = NULL, mustWork = TRUE)
tab<-flowjointure(flows,bkg,"EPT_NUM")
#Format long with only origin, destination and distance parameters:
tab.distance<-flowdist(tab, dist.method = "euclidian",result = "dist")
#Format long with with all parameters: coordinates, distance, mouvement
tab.distance<-flowdist(tab, dist.method = "euclidian",result = "flowdist")
}
