% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ring_dir.R
\name{check_ring_dir}
\alias{check_ring_dir}
\title{Polygon rings directions are checked and corrected if asked.}
\usage{
check_ring_dir(polygons, check.only = TRUE)
}
\arguments{
\item{polygons}{a sfc object which contains simple feature geometry of
types \code{POLYGON} or \code{MULTIPOLYGON}}

\item{check.only}{a boolean which indicates if the function only
checks the ring direction (\code{check.only=TRUE}) or checks and
corrects the polygon direction (\code{check.only=FALSE})}
}
\value{
Either a logical vector which indicates if line i of polygons
is in the right direction (\code{TRUE}) or not or the corrected sfc object
}
\description{
Polygon ring are seen from above: exterior ring counter clockwise,
holes clockwise
}
\examples{
  data(usa)
  all(check_ring_dir(sf::st_geometry(usa), check.only=TRUE))


}
