% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/legends.R
\name{legendGradLines}
\alias{legendGradLines}
\title{Legend for Graduated Size Lines Maps}
\usage{
legendGradLines(pos = "topleft", title.txt = "Title of the legend",
  title.cex = 0.8, values.cex = 0.6, breaks, lwd, col, values.rnd = 2,
  cex = 1, frame = FALSE)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright".}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{values.cex}{size of the values in the legend.}

\item{breaks}{break points in sorted order to indicate the intervals
for assigning the width of the lines}

\item{lwd}{a vector giving the width of the lines.}

\item{col}{color of symbols.}

\item{values.rnd}{number of decimal places of the values in
the legend.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{frame}{whether to add a frame to the legend (TRUE) or
not (FALSE).}
}
\description{
Plot legend for graduated size lines maps.
}
\examples{
data("nuts2006")
plot(nuts0.spdf)
box()
legendGradLines(title.txt = "Title of the legend",
                pos = "topright",
                title.cex = 0.8,
                values.cex = 0.6, breaks = c(1,2,3,4,10.2,15.2),
                lwd = c(0.2,2,4,5,10),
                col ="blue", values.rnd =2)
}

