% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tilesLayer.R
\name{tilesLayer}
\alias{tilesLayer}
\title{Plot Tiles from Open Map Servers}
\usage{
tilesLayer(x, add = FALSE)
}
\arguments{
\item{x}{an OpenStreetMap object; the \link{getTiles} function outputs these 
objects.}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot tiles from open map servers.
}
\note{
This function is a wrapper for plot.OpenStreetMap from the 
OpenStreetMap package.
}
\examples{
\dontrun{
data("nuts2006")
# Download the tiles, nuts0.spdf extent
EuropeStamen <- getTiles(spdf = nuts0.spdf, type = "stamen-watercolor")
class(EuropeStamen)
# Plot the tiles
tilesLayer(EuropeStamen)
# Plot countries
plot(nuts0.spdf, add=TRUE)
# Map tiles sources
mtext(text = "Map tiles by Stamen Design, under CC BY 3.0. Data by OpenStreetMap, under CC BY SA.", 
      side = 1, adj = 0, cex = 0.7, font = 3)
}
}
\seealso{
\link{getTiles}
}

