% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font.R
\name{font}
\alias{font}
\title{Font}
\usage{
font(x, size = NULL, weight = NULL, style = NULL, case = NULL, family = NULL)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{size}{One of \code{1}, \code{2}, \code{3}, \code{4}, \code{5}, or \code{6} specifying a font size, defaults
to \code{NULL}, in which case the argument is ignored. The sizes follow the
conventions of heading tags, so \code{1} is the largest font and \code{6} the
smallest.}

\item{weight}{One of \code{"light"}, \code{"lighter"}, \code{"normal"}, \code{"bolder"}, or \code{"bold"} specifying the font
weight, defaults to \code{NULL}, in which case the argument is ignored.

If \code{"bolder"} or \code{"lighter"}, the font weight is changed relative to the
current font weight.}

\item{style}{One of \code{"italic"} or \code{"normal"} specifying the font
style, defaults to \code{NULL}, in which case the argument is ignored.}

\item{case}{One of \code{"upper"}, \code{"lower"}, or \code{"title"} specifying the font case,
default to \code{NULL}, in which case the argument is ignored.}

\item{family}{One of \code{"sans-serif"} or \code{"monospace"} specifying the font
family, defaults to \code{NULL}, in which case the argument is ignored.}
}
\description{
The \code{font()} function adjusts the size, weight, style, case, and family of
the font of a tag element.
}
\section{Weights}{
\if{html}{\out{<div class="r">}}\preformatted{p(
  .style \%>\%
    font(weight = "bold"),
  "Curabitur lacinia pulvinar nibh."
)
}\if{html}{\out{</div>}}\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<p class="cas-font-bold">
}}


Curabitur lacinia pulvinar nibh.\if{html}{\out{
</p>
}}
\if{html}{\out{
<!--/html_preserve-->
}}
\if{html}{\out{<div class="r">}}\preformatted{p(
  .style \%>\%
    font(weight = "light"),
  "Proin quam nisl, tincidunt et."
)
}\if{html}{\out{</div>}}\if{html}{\out{
<!--html_preserve-->
}}
\if{html}{\out{
<p class="cas-font-light">
}}


Proin quam nisl, tincidunt et.\if{html}{\out{
</p>
}}
\if{html}{\out{
<!--/html_preserve-->
}}
}

\examples{

library(htmltools)

p(
  .style \%>\%
    text("indigo") \%>\%
    font(weight = "bold"),
  "Phasellus at dui in ligula mollis ultricies."
)

}
