% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphahull.R
\name{sc_convex}
\alias{sc_convex}
\alias{sc_convex.default}
\alias{sc_convex.scree}
\alias{sc_convex.list}
\title{Compute convex scagnostic measure}
\usage{
sc_convex(x, y)

\method{sc_convex}{default}(x, y)

\method{sc_convex}{scree}(x, y = NULL)

\method{sc_convex}{list}(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's convex score.
}
\description{
Compute convex scagnostic measure
}
\examples{
  require(ggplot2)
  require(dplyr)
  ggplot(features, aes(x=x, y=y)) +
     geom_point() +
     facet_wrap(~feature, ncol = 5, scales = "free")
  features \%>\% group_by(feature) \%>\% summarise(convex = sc_convex(x,y))
  sc_convex(datasaurus_dozen_wide$away_x, datasaurus_dozen_wide$away_y)
}
