% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catching-n-plans.R
\name{make_plans}
\alias{make_plans}
\alias{catchr-plans}
\title{Making catchr plans}
\usage{
make_plans(..., .opts = catchr_opts())
}
\arguments{
\item{\dots}{Named and unnamed arguments for making plans. See 'Input' for more detail.}

\item{.opts}{The options to be used for the plan. Generally passed in using \code{\link[=catchr_opts]{catchr_opts()}}.}
}
\description{
Customizing how conditions are handled in catchr is done by giving catchr 'plans' for when it encounters particular conditions. These plans are essentially just lists of functions that are called in order, and that take in the particular condition as an argument.

However, since catchr evaluates things \link[=catchr-DSL]{slightly differently than base R}, the user input to make these plans has to first be passed into \code{make_plans} (or, for setting the default plan, \code{\link[=set_default_plan]{set_default_plan()}}). \code{make_plans} also lets users specify options for how they want these plans to be evaluated with the \code{.opts} argument (see \code{\link[=catchr_opts]{catchr_opts()}} for more details).

See the 'Input' section below and the examples for how to use \code{make_plans}.
}
\section{Input}{


User input to \code{make_plans} is very similar to how one makes handlers for \code{\link[base:withCallingHandlers]{base::withCallingHandlers()}}, \code{\link[base:tryCatch]{base::tryCatch()}} and \code{rlang}'s \code{\link[rlang:with_handlers]{rlang::with_handlers()}}, albeit with some important differences.

Like the functions above, the name of each argument determines which type of condition it will be the plan for. Hence, \code{warnings = fn} will apply the \code{fn} function to the warnings raised in evaluating \code{expr}.

However, \emph{unnamed} arguments are \emph{also} accepted: the value of any unnamed arguments will be treated as the type of a condition, which will then have the default plan assigned to it, as specified either in \code{.opts = catchr_opts(...)} or via \code{getOption("catchr.default_plan")}. Unnamed arguments must be either strings or unquoted expressions which will then be converted to strings. Currently, unnamed arguments are \emph{never} evaluated, so cannot be calls that evaluate to strings.

\strong{However, this may change in future versions of catchr.}
}

\section{Passing input in programmatically}{


\code{make_plans} supports \code{\link[rlang]{quasiquotation}}, so if for some reason one wishes to pass input into \code{make_plans} via a different function, programmatically, etc., one may do so by splicing in quosures. See below for examples.
}

\examples{
# ### INPUT EXAMPLES ###########################

# Named arguments --------------------------------------

#   * single functions:
p <- make_plans(warning = str, message = function(x) print(x))

#   * single unquoted expressions and strings
#     (must match catchr's special reserved terms, e.g., 'muffle', 'exit', etc.):
p <- make_plans(message = muffle, condition = "collect")

#   * lists or vectors of any combinatin of the above:
p <- make_plans(error = list(collect, "exit"),
                message = c(cat, "muffle"))

#   * anything that evaluates to the above:
fn <- function() { list(cat, "muffle") }
p <- make_plans(message = fn() )

# Unnamed arguments ----------------------

#   * single strings:
p <- make_plans("warning","condition")

#   * unquoted expressions:
p <- make_plans(warning,condition)

#   * Currently, does NOT accept anything that evaluates to strings:
#       (However, this may change in the future)
\dontrun{
string_fn <- function() { "condition" }
make_plans(string_fn()) # will currently raise error
}

# Mixes of both --------------------------
p <- make_plans("warning", message = c(towarning, muffle),
                condition = print)

# ### Quasiquotation and splicing in the arguments ###############

q <- rlang::quo(function(cond) {print(cond)})
name <- "warning"

print_plan <- make_plans(!!name := !!q)

# 'message' will be assigned the default plan
qs <- rlang::quos(warning = muffle, error = exit, message)
random_plan <- make_plans(!!!qs)

}
