% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_edge.R
\name{dag_edge}
\alias{dag_edge}
\title{Add an edge (or edges) between nodes in a graph object.}
\usage{
dag_edge(graph, from, to, type = as.character(NA))
}
\arguments{
\item{graph}{a graph object of class \code{causact_graph}.}

\item{from}{a character vector representing the parent nodes label or description from which the edge is connected.}

\item{to}{the child node label or description from which the edge is connected.}

\item{type}{character string used to represent the DiagrammeR line type (e.g. \code{"solid"}).  Use \code{type = "extract"} to encourage causact to only pass indexed elements of the parent node to each instance of the child node.  Specify \code{type = "solid"} to override any automated extract behavior.}
}
\value{
a graph object of class \code{dgr_graph} with additional edges created by this function.
}
\description{
With a graph object of class \code{causact_graph} created from \code{dag_create}, add an edge between nodes in the graph.  Vector recycling is used for all arguments.
}
\examples{
# Create a graph with 2 connected nodes
dag_create() \%>\%
  dag_node("X") \%>\%
  dag_node("Y") \%>\%
  dag_edge(from = "X", to = "Y") \%>\%
  dag_render(shortLabel = TRUE)
}
