% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_make_formula.R
\name{eval_make_formula}
\alias{eval_make_formula}
\title{Evaluates and Makes Formula for regression of exposure or risk factor or outcome on its parents in a causal Bayesian network directed acyclic graph.}
\usage{
eval_make_formula(data, in_out, model_list, w, addCustom = FALSE, custom = "")
}
\arguments{
\item{data}{A wide format data containing all the risk factors, confounders, exposures and outcomes within the causal DAG Bayesian network.}

\item{in_out}{This defines the causal directed acyclic graph (DAG). A list of length 2. It is defined as a two dimensional list consisting of, firstly, the first list, inlist, i.e. a list of the parents of each variable of interest corresponding to its column name in the data. Splines can be included here if they are to be modelled as splines. Secondly, the second list, outlist, contains a list of a single name of exposure or risk factor or outcome in form of characters i.e. a list of each variable of interest (risk factors, exposures and outcome) corresponding to its column name in the data. Splines should not be input here, only the column names of the variables of interest in the data. The order at which variables are defined must satisfy (i) It is important that variables are defined in the same order in both lists e.g. the first risk factor defined in outlist has its parents listed first in inlist, the second risk factor defined in outlist has its parents listed secondly in inlist and so on. The package assumes this ordering and will not work if this order is violated. (ii) Note it is important also that the order at which the variables are defined is such that all parents of that variable are defined before it. See example in tutorial.}

\item{model_list}{is a list of models fitted for each of the variables in in_outArg[[2]] (or in_outArg\$outlist ) based on its parents given in in_outArg[[1]] ( or in_out\$inlist ). By default this is set to an empty list. In the default setting, the models are fitted automatically by the 'causalPAF' package based on the order of the variables input in the parameter in_outArg. See the tutorial for more examples. Alternatively, the user can supply their own fitted models here by populating ``model_listArg'' with their own fitted models for each risk factor, mediator, exposure and response variable. But the order of these models must be in the same order of the variables in the second list of in_outArg ( in_outArg[[2]] ) and these models be defined within a list, list(), of the same length as in_outArg[[2]]. See tutorial for further examples.}

\item{w}{Column of weights for case control matching listing in same order as patients in data.}

\item{addCustom}{Logical TRUE or FALSE indicating whether a customised interaction term is to be added to the each regression. The interaction term can include splines.}

\item{custom}{text containing the customised interaction term to be added to each regression. The text should be enclosed in inverted commas. Splines can be included within the interaction terms. See tutorial for examples.}
}
\value{
\itemize{
\item{model_listReturn[[1]] }{model list A}
\item{model_listReturn[[2]] }{model list B}
\item{model_listReturn[[3]] }{model list C}
\item{model_listReturn[[4]] }{model list D}
\item{model_listReturn[[5]] }{model list E}
\item{model_listReturn[[6]] }{model list F}
\item{model_listReturn[[7]] }{model list G}
\item{model_listReturn[[8]] }{model list H}
\item{model_listReturn[[9]] }{model list I}
\item{model_listReturn[[10]] }{model list J}
\item{model_listReturn[[11]] }{model list K}
}
}
\description{
Evaluates and Makes Formula for regression of exposure or risk factor or outcome on its parents in a causal Bayesian network directed acyclic graph. Given a causal Bayesian network, directed acyclic graph (DAG) where arrows representing
causal dependencies between confounders, risk factors/exposure and disease, together with a sensible probability distribution on
the graph that respects these causal dependencies. To consistently estimate causal effects that risk factors may have on each
other and on disease, we need to make a strong no unmeasured confounding assumption: that is common causes of nodes in the graph,
which may be causes of two risk factors or a cause of risk factor and disease, are also included as nodes in the graph.
Causal Bayesian networks have a local Markov property that the conditional probability distribution of any node Xj, given values
for the other variables in the network, only depends on the values $x_{pa}_{j}$ of the parent nodes.
}
\keyword{internal}
