% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{constraintscheck}
\alias{constraintscheck}
\title{Check constraints}
\usage{
constraintscheck(constrainttext, graphres)
}
\arguments{
\item{constrainttext}{A string representing a constraint.}

\item{graphres}{An \code{igraph} object representing a DAG.}
}
\value{
\code{TRUE} if all check pass; else \code{FALSE}.
}
\description{
Check that a user-provided constraint is parsable, has valid variables and relations.
}
\examples{
graphres <- graph_from_literal(Z -+ X, X -+ Y, Ul -+ Z, Ur -+ X, Ur -+ Y)
V(graphres)$leftside <- c(1, 0, 0, 1, 0)
V(graphres)$latent <- c(0, 0, 0, 1, 1)
V(graphres)$nvals <- c(3, 2, 2, 2, 2)
V(graphres)$exposure <- c(0, 1, 0, 0, 0)
V(graphres)$outcome <- c(0, 0, 1, 0, 0)
E(graphres)$rlconnect <- c(0, 0, 0, 0, 0)
E(graphres)$edge.monotone <- c(0, 0, 0, 0, 0)
constrainttext <- "X(Z = 1) >= X(Z = 0)"
constraintscheck(constrainttext = constrainttext, graphres = graphres) # TRUE
}
