% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{ggplot2.CFA}
\alias{ggplot2.CFA}
\title{ggplot2.CFA}
\usage{
ggplot2.CFA(cfaseobj, setype = "pointwise", ylim = NULL,
  xlabel = NULL, ylabel = NULL, legend = FALSE)
}
\arguments{
\item{cfaseobj}{a CFASE object to plot}

\item{setype}{whether to plot pointwise, uniform, or both standard errors}

\item{ylim}{optional y limits on the plot}

\item{xlabel}{optional x axis labels}

\item{ylabel}{optional y axis labels}

\item{legend}{boolean for whether or not to plot a legend (tends to look
better with this option set to FALSE)}
}
\value{
ggplot2 object
}
\description{
function for plotting results from counterfactual analysis
 using ggplot2
}
\examples{
\dontrun{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)

## obtain counterfactual results
out <- cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr",
xformla2=~HEDUC, method2="qr", iters=10, tau1=seq(.05,.95,.05),
tau2=seq(.05,.95,.05))

## get the difference between the average that adjusts for covariates and
## the one that does not
ggplot2.CFA(getResDiff.CFA(out$cfa1, out$cfa2, E), setype="uniform")
} 

}
