% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_weekly_flu_report.r
\name{get_weekly_flu_report}
\alias{get_weekly_flu_report}
\title{Retrieves (high-level) weekly influenza surveillance report from the CDC}
\usage{
get_weekly_flu_report()
}
\value{
\code{tbl_df} (also classed with \code{cdcweeklyreport}) with six
        columns: \code{year}, \code{week_number}, \code{state}, \code{color},
        \code{label}, \code{subtitle}
}
\description{
The CDC publishes a \href{http://www.cdc.gov/flu/weekly/usmap.htm}{weekly
influenza report} detailing high-level flu activity per-state. They also
publish a data file (see \code{References}) of historical report readings.
This function reads that XML file and produces a long \code{data_frame}
with the historical surveillance readings.\cr
\cr
This function provides similar data to \code{\link{get_state_data}} but without
the reporting source metadata and a limit on the historical flu information.
}
\examples{
\dontrun{
get_weekly_flu_report()
}
}
\references{
\url{http://www.cdc.gov/flu/weekly/flureport.xml}
}

