% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzzz.R
\name{Csurv}
\alias{Csurv}
\title{Survival probability conditional to the observed data estimation for right censored data.}
\usage{
Csurv(Y, M, censor, t, h = NULL, kernel = "normal")
}
\arguments{
\item{Y}{The numeric vector of event-times or observed times.}

\item{M}{The numeric vector of marker values for which we want to compute the time-dependent ROC curves.}

\item{censor}{The censoring indicator, \code{1} if event, \code{0} otherwise.}

\item{t}{A scaler time point at which we want to compute the time-dependent ROC curve.}

\item{h}{A scaler for the bandwidth of Beran's weight calculaions. The defualt is using the method of Sheather and Jones (1991).}

\item{kernel}{A character string giving the type kernel to be used: "\code{normal}", "\code{epanechnikov}", , "\code{tricube}", "\code{boxcar}", "\code{triangular}", or "\code{quartic}". The defaults is "\code{normal}" kernel density.}
}
\value{
Return a vectors:

\code{positive    }    \code{P(T<t|Y,censor,M)}.

\code{negative    }     \code{P(T>t|Y,censor,M)}.
}
\description{
Survival probability conditional to the observed data estimation for right censored data.
}
\references{
Beyene, K. M. and El Ghouch A. (2019). Smoothed time-dependent ROC curves for right-censored survival data. <\url{https://dial.uclouvain.be/pr/boreal/object/boreal:219643}>.

Li, Liang, Bo Hu and Tom Greene (2018).  A simple method to estimate the time-dependent receiver operating characteristic curve and the area under the curve with right censored data, Statistical Methods in Medical Research, 27(8): 2264-2278.

Pablo Martínez-Camblor and Gustavo F. Bayón and Sonia Pérez-Fernández (2016). Cumulative/dynamic roc curve estimation, Journal of Statistical Computation and Simulation, 86(17): 3582-3594.
}
\keyword{internal}
