% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_questionnaire.R
\name{questionnaire}
\alias{questionnaire}
\title{Questionnaires used in the data collection of Brazil's censuses}
\usage{
questionnaire(year = 2010, type = NULL, showProgress = TRUE, cache = TRUE)
}
\arguments{
\item{year}{Numeric. Year of reference in the format \code{yyyy}. Defaults to
\code{2010}.}

\item{type}{Character. The type of questionnaire used in the survey, whether
the \code{"long"} one used in the sample component of the census, or the
\code{"short"} one, which is answered by more households. Options include
\code{c("long", "short")}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display download progress
bar. The progress bar only reflects only the downloading
time, not the time to load the data to memory.}

\item{cache}{Logical. Whether the function should read the data cached
locally, which is much faster. Defaults to \code{TRUE}. The first time the
user runs the function, \code{censobr} will download the file and store it
locally so that the file only needs to be download once. If \code{FALSE},
the function will download the data again and overwrite the local file.}
}
\value{
Opens a \code{.pdf} file on the browser
}
\description{
Open on a browser the questionnaire used in the data collection of Brazil's
censuses
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(censobr)

# Open questionnaire on browser
questionnaire(year = 2010, type = 'long', showProgress = FALSE)
\dontshow{\}) # examplesIf}
}
\concept{Questionnaire}
